//
//  IFActivityView.h
//  Downloader
//
//  Created by LiDong on 13-3-17.
//  Copyright (c) 2013年 LiDong. All rights reserved.
//

#import <UIKit/UIKit.h>

@class IFActivityView;

@protocol IFActivityViewDelegate <NSObject>
@optional
- (void)activityViewDidDismiss:(IFActivityView *)activityView;
@end

@interface IFActivityView : UIView {
    UIView *_contentView;
    UILabel *_titleLabel;
    UIButton *_closeButton;
    UIActivityIndicatorView *_activieyIndicatorView;
    __weak id<IFActivityViewDelegate> _delegate;
}

@property (nonatomic, weak) id<IFActivityViewDelegate> delegate;

- (id)initWithTitle:(NSString *)title;
- (void)setHidesCloseButton:(BOOL)hidden;
- (void)show;
- (void)done;
- (void)abort;

@end
